functions {

}


data {
  int<lower=1> N_obs;                               // number of non-censored observations
  int<lower=1> N_cens;                              // number of censored observations
  int<lower=2> N_group;                             // number of groups
  int<lower=2> N_ind;                               // number of individuals

  real<lower=0> dlimit;                             // detection limit

  vector<lower=dlimit>[N_obs] gameto_Pfs25;         // non-censored observations (concentrations)
  int<lower=1,upper=N_ind>    ID_obs[N_obs];        // ID
  int<lower=1,upper=N_group> group_obs[N_obs];      // group

  int<lower=1,upper=N_ind>    ID_cens[N_cens];      // ID
  int<lower=1,upper=N_group>  group_cens[N_cens];   // group
}


transformed data{
  real dlimit_log;
  vector[N_obs] gameto_Pfs25_log;

  gameto_Pfs25_log = log(gameto_Pfs25);
  dlimit_log = log(dlimit);
}


parameters {
  // N.B.: parameters are for a model of log-concentrations
     real mu_group_ref;               // mean of reference group (defined as group 4 in model section below)
     real delta_group[N_group-1];     // group deviations from reference group
     real delta_ind[N_ind];           // individual-level deviations from the group mean (normalised)
     real<lower=0> delta_ind_sigma;   // standard deviation of individual-level deviations
     real<lower=0> sigma_obs;         // standard deviation of measurement error in observations

     real<upper=dlimit_log> gameto_Pfs25_log_cens[N_cens];  // Unknown value of censored observations
}


transformed parameters {

}


model {
     vector[N_obs] gameto_Pfs25_obs_mu;    // Log expected value of non-censored observations
     vector[N_cens] gameto_Pfs25_cens_mu;  // Log expected value of censored observations
     real mu_group[N_group];               // Log expected group mean

  // Construct linear predictors (group 4 = reference group)
     for (i in 1:(N_group-1)) mu_group[i] = mu_group_ref + delta_group[i];
     mu_group[N_group] = mu_group_ref;

     for (i in 1:N_obs)  gameto_Pfs25_obs_mu[i]  = mu_group[group_obs[i]]  + delta_ind_sigma * delta_ind[ID_obs[i]];
     for (i in 1:N_cens) gameto_Pfs25_cens_mu[i] = mu_group[group_cens[i]] + delta_ind_sigma * delta_ind[ID_cens[i]];

  // =========================== //
  // Increment the log-posterior //
  // =========================== //

  // Priors
     // implicit: mu_group_ref ~ improper uniform prior
     // implicit: delta_group ~ improper uniform prior
     delta_ind ~ normal(0, 1);
     delta_ind_sigma ~ normal(0, 3);
     sigma_obs ~ normal(0, 3);

  // Likelihood
     gameto_Pfs25_log ~ normal(gameto_Pfs25_obs_mu, sigma_obs);
     gameto_Pfs25_log_cens ~ normal(gameto_Pfs25_cens_mu, sigma_obs);
}


generated quantities {
     real p_group4_highest;

     p_group4_highest = 1;
     if (delta_group[1] >= 0 || delta_group[2] >= 0 || delta_group[3] >= 0) p_group4_highest = 0;
}
